package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.Notificaciones;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0428t00DaoImpl generated by UDA, 16-jun-2017 8:19:35.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class NotificacionesDaoImpl implements NotificacionesDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Notificaciones> rwMap = new RowMapper<Notificaciones>() {
		public Notificaciones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Notificaciones(resultSet.getInt("IDNOTIFICACION028"),
					resultSet.getDate("FECHARECEPCION028"),
					resultSet.getDate("FECHALECTURA028"),
					resultSet.getString("REMITENTE028"),
					resultSet.getString("MENSAJE028"),
					resultSet.getString("ANOAPE028"),
					resultSet.getString("TERAPE028"),
					resultSet.getInt("NUMAPE028"),
					resultSet.getString("DESTINATARIO028"),
					resultSet.getString("USUARIOLECTURA028"));
		}
	};

	private RowMapper<Notificaciones> rwMapPK = new RowMapper<Notificaciones>() {
		public Notificaciones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Notificaciones(resultSet.getInt("IDNOTIFICACION028"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
 dataSource
	 *            DataSource

	 */
	private RowMapper<JerarquiaDto<Notificaciones>> rwMapJerarquia = new RowMapper<JerarquiaDto<Notificaciones>>() {
		public JerarquiaDto<Notificaciones> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			Notificaciones ab0428t00 = new Notificaciones(
					resultSet.getInt("IDNOTIFICACION028"),
					resultSet.getDate("FECHARECEPCION028"),
					resultSet.getDate("FECHALECTURA028"),
					resultSet.getString("REMITENTE028"),
					resultSet.getString("MENSAJE028"),
					resultSet.getString("ANOAPE028"),
					resultSet.getString("TERAPE028"),
					resultSet.getInt("NUMAPE028"),
					resultSet.getString("DESTINATARIO028"),
					resultSet.getString("USUARIOLECTURA028"));

			JerarquiaDto<Notificaciones> jerarquia = new JerarquiaDto<Notificaciones>();
			jerarquia.setModel(ab0428t00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(
					Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(
					Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  Ab0428t00
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @return the notificaciones
	 */
	public Notificaciones add(Notificaciones ab0428t00) {
		String query = "INSERT INTO AB0428S00 (IDNOTIFICACION_028, FECHA_RECEPCION_028, FECHA_LECTURA_028, REMITENTE_028, MENSAJE_028, ANOAPE_028, TERAPE_028, NUMAPE_028,DESTINATARIO_028,USUARIO_LECTURA_028) VALUES (?,?,?,?,?,?,?,?,?,?)";

		ab0428t00.setIdnotificacion028(
				Secuencias.NOTIFICACIONES.getNextInteger(jdbcTemplate));

		this.jdbcTemplate.update(query, ab0428t00.getIdnotificacion028(),
				ab0428t00.getFechaRecepcion028(),
				ab0428t00.getFechaLectura028(), ab0428t00.getRemitente028(),
				ab0428t00.getMensaje028(), ab0428t00.getAnoape028(),
				ab0428t00.getTerape028(), ab0428t00.getNumape028(),
				ab0428t00.getDestinatario028(),
				ab0428t00.getUsuariolectura028());
		return ab0428t00;
	}

	/**
	 * Updates a single row in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  Ab0428t00
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @return the notificaciones
	 */
	public Notificaciones update(Notificaciones ab0428t00) {
		String query = "UPDATE AB0428S00 SET FECHA_RECEPCION_028=?, FECHA_LECTURA_028=?, REMITENTE_028=?, MENSAJE_028=?, ANOAPE_028=?, TERAPE_028=?, NUMAPE_028=?,DESTINATARIO_028 = ?,USUARIO_LECTURA_028= ?  WHERE IDNOTIFICACION_028=?";
		this.jdbcTemplate.update(query, ab0428t00.getFechaRecepcion028(),
				ab0428t00.getFechaLectura028(), ab0428t00.getRemitente028(),
				ab0428t00.getMensaje028(), ab0428t00.getAnoape028(),
				ab0428t00.getTerape028(), ab0428t00.getNumape028(),
				ab0428t00.getDestinatario028(),
				ab0428t00.getUsuariolectura028(),
				ab0428t00.getIdnotificacion028());
		return ab0428t00;
	}

	/**
	 * Finds a single row in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  Ab0428t00
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @return the notificaciones
	 */
	@Transactional(readOnly = true)
	public Notificaciones find(Notificaciones ab0428t00) {
		String query = "SELECT t1.IDNOTIFICACION_028 IDNOTIFICACION028, t1.FECHA_RECEPCION_028 FECHARECEPCION028, t1.FECHA_LECTURA_028 FECHALECTURA028, t1.REMITENTE_028 REMITENTE028, t1.MENSAJE_028 MENSAJE028, t1.ANOAPE_028 ANOAPE028, t1.TERAPE_028 TERAPE028, t1.NUMAPE_028 NUMAPE028,DESTINATARIO_028 DESTINATARIO028,USUARIO_LECTURA_028 USUARIOLECTURA028 FROM AB0428S00 t1  WHERE t1.IDNOTIFICACION_028 = ?  ";

		List<Notificaciones> ab0428t00List = this.jdbcTemplate.query(query,
				this.rwMap, ab0428t00.getIdnotificacion028());

		Notificaciones notificacion = (Notificaciones) DataAccessUtils
				.uniqueResult(ab0428t00List);
		if (notificacion != null && notificacion.getFechaLectura028() == null) {
			// marcamos como leido
			notificacion.setFechaLectura028(new Date());
			notificacion.setUsuariolectura028(
					UtilSeguridad.getInstance().getNombre());
			notificacion = this.update(notificacion);
		}

		return notificacion;
	}

	/**
	 * Removes a single row in the Ab0428t00 table.
	 * 
	 *  ab0428t00            Ab0428t00
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 */
	public void remove(Notificaciones ab0428t00) {
		String query = "DELETE FROM AB0428S00 WHERE IDNOTIFICACION_028=?";
		this.jdbcTemplate.update(query, ab0428t00.getIdnotificacion028());
	}

	/**
	 * Finds a list of rows in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0428t00>
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Notificaciones> findAll(Notificaciones ab0428t00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDNOTIFICACION_028 IDNOTIFICACION028,t1.FECHA_RECEPCION_028 FECHARECEPCION028,t1.FECHA_LECTURA_028 FECHALECTURA028,t1.REMITENTE_028 REMITENTE028,t1.MENSAJE_028 MENSAJE028,t1.ANOAPE_028 ANOAPE028,t1.TERAPE_028 TERAPE028,t1.NUMAPE_028 NUMAPE028, DESTINATARIO_028 DESTINATARIO028,USUARIO_LECTURA_028 USUARIOLECTURA028 ");
		query.append("FROM AB0428S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0428t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Notificaciones>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0428t00 table using like.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0428t00>
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Notificaciones> findAllLike(Notificaciones ab0428t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDNOTIFICACION_028 IDNOTIFICACION028,t1.FECHA_RECEPCION_028 FECHARECEPCION028,t1.FECHA_LECTURA_028 FECHALECTURA028,t1.REMITENTE_028 REMITENTE028,t1.MENSAJE_028 MENSAJE028,t1.ANOAPE_028 ANOAPE028,t1.TERAPE_028 TERAPE028,t1.NUMAPE_028 NUMAPE028, DESTINATARIO_028 DESTINATARIO028,USUARIO_LECTURA_028 USUARIOLECTURA028 ");
		query.append("FROM AB0428S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0428t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Notificaciones>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0428t00 table.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  Long
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Notificaciones ab0428t00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0428S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0428t00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0428t00 table using like.
	 * 
	 *  ab0428t00
	 *            Ab0428t00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Notificaciones ab0428t00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0428S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0428t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0428t00 selected for rup_table.
	 * 
	 *  ab0428t00            Ab0428t00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0428t00>>
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Notificaciones>> reorderSelection(
			Notificaciones ab0428t00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDNOTIFICACION_028 IDNOTIFICACION028,t1.FECHA_RECEPCION_028 FECHARECEPCION028,t1.FECHA_LECTURA_028 FECHALECTURA028,t1.REMITENTE_028 REMITENTE028,t1.MENSAJE_028 MENSAJE028,t1.ANOAPE_028 ANOAPE028,t1.TERAPE_028 TERAPE028,t1.NUMAPE_028 NUMAPE028, DESTINATARIO_028 DESTINATARIO028,USUARIO_LECTURA_028 USUARIOLECTURA028 ");
		// FROM
		query.append("FROM AB0428S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0428t00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Notificaciones.class, filterParamList,
				"IDNOTIFICACION_028");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<Notificaciones>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0428t00
	 *  searchParams            Ab0428t00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0428t00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Notificaciones>> search(Notificaciones filterParams,
			Notificaciones searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDNOTIFICACION_028 IDNOTIFICACION028,t1.FECHA_RECEPCION_028 FECHARECEPCION028,t1.FECHA_LECTURA_028 FECHALECTURA028,t1.REMITENTE_028 REMITENTE028,t1.MENSAJE_028 MENSAJE028,t1.ANOAPE_028 ANOAPE028,t1.TERAPE_028 TERAPE028,t1.NUMAPE_028 NUMAPE028, DESTINATARIO_028 DESTINATARIO028,USUARIO_LECTURA_028 USUARIOLECTURA028");
		// FROM
		query.append("FROM AB0428S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Notificaciones.class, filterParamList,
				searchSQL, searchParamList, from_alias, "IDNOTIFICACION_028");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<Notificaciones>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0428t00            Ab0428t00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0428t00 the filterab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(Notificaciones filterab0428t00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDNOTIFICACION_028 IDNOTIFICACION028,t1.FECHA_RECEPCION_028 FECHARECEPCION028,t1.FECHA_LECTURA_028 FECHALECTURA028,t1.REMITENTE_028 REMITENTE028,t1.MENSAJE_028 MENSAJE028,t1.ANOAPE_028 ANOAPE028,t1.TERAPE_028 TERAPE028,t1.NUMAPE_028 NUMAPE028, DESTINATARIO_028 DESTINATARIO028,USUARIO_LECTURA_028 USUARIOLECTURA028");
		// FROM
		query.append("FROM AB0428S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0428t00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Notificaciones.class,
						query, params, "IDNOTIFICACION_028");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab0428t00 table.
	 * 
	 *  filterAb0428t00
	 *            Ab0428t00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<JerarquiaDto<Ab0428t00>>
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<Notificaciones>> findAllLikeJerarquia(
			Notificaciones filterAb0428t00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDNOTIFICACION_028 IDNOTIFICACION028,t1.FECHA_RECEPCION_028 FECHARECEPCION028,t1.FECHA_LECTURA_028 FECHALECTURA028,t1.REMITENTE_028 REMITENTE028,t1.MENSAJE_028 MENSAJE028,t1.ANOAPE_028 ANOAPE028,t1.TERAPE_028 TERAPE028,t1.NUMAPE_028 NUMAPE028, DESTINATARIO_028 DESTINATARIO028,USUARIO_LECTURA_028 USUARIOLECTURA028 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0428S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0428S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0428t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "IDNOTIFICACION_028", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 *  filterAb0428t00            Ab0428t00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  Long
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Notificaciones filterAb0428t00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0428S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0428S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0428t00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "IDNOTIFICACION_028", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 *  filterAb0428t00            Ab0428t00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  List<TableRowDto<Ab0428t00>>
	 *
	 * @param filterAb0428t00 the filter ab 0428 t 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Notificaciones>> findAllChild(
			Notificaciones filterAb0428t00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0428S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0428S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0428t00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "IDNOTIFICACION_028", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Notificaciones>(
								this.rwMapPK, "IDNOTIFICACION_028"),
						params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0428t00 entity.
	 * 
	 *  ab0428t00            Ab0428t00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Notificaciones ab0428t00) {

		StringBuilder where = new StringBuilder(
				NotificacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0428t00 != null && ab0428t00.getIdnotificacion028() != null) {
			where.append(" AND t1.IDNOTIFICACION_028 = ?");
			params.add(ab0428t00.getIdnotificacion028());
		}
		if (ab0428t00 != null && ab0428t00.getFechaRecepcion028() != null) {
			where.append(" AND t1.FECHA_RECEPCION_028 = ?");
			params.add(ab0428t00.getFechaRecepcion028());
		}
		if (ab0428t00 != null && ab0428t00.getFechaLectura028() != null) {
			where.append(" AND t1.FECHA_LECTURA_028 = ?");
			params.add(ab0428t00.getFechaLectura028());
		}
		if (ab0428t00 != null && ab0428t00.getRemitente028() != null) {
			where.append(" AND t1.REMITENTE_028 = ?");
			params.add(ab0428t00.getRemitente028());
		}
		if (ab0428t00 != null && ab0428t00.getMensaje028() != null) {
			where.append(" AND t1.MENSAJE_028 = ?");
			params.add(ab0428t00.getMensaje028());
		}
		if (ab0428t00 != null && ab0428t00.getAnoape028() != null) {
			where.append(" AND t1.ANOAPE_028 = ?");
			params.add(ab0428t00.getAnoape028());
		}
		if (ab0428t00 != null && ab0428t00.getTerape028() != null) {
			where.append(" AND t1.TERAPE_028 = ?");
			params.add(ab0428t00.getTerape028());
		}
		if (ab0428t00 != null && ab0428t00.getNumape028() != null) {
			where.append(" AND t1.NUMAPE_028 = ?");
			params.add(ab0428t00.getNumape028());
		}
		if (ab0428t00 != null && ab0428t00.getDestinatario028() != null) {
			where.append(" AND t1.DESTINATARIO_028 = ?");
			params.add(ab0428t00.getDestinatario028());
		}
		if (ab0428t00 != null && ab0428t00.getUsuariolectura028() != null) {
			where.append(" AND t1.USUARIO_LECTURA_028 = ?");
			params.add(ab0428t00.getUsuariolectura028());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0428t00 entity.
	 * 
	 *  ab0428t00            Ab0428t00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0428t00 the ab 0428 t 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Notificaciones ab0428t00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				NotificacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0428t00 != null && ab0428t00.getIdnotificacion028() != null) {
			where.append(" AND t1.IDNOTIFICACION_028 = ?");
			params.add(ab0428t00.getIdnotificacion028());
		}
		if (ab0428t00 != null && ab0428t00.getFechaRecepcion028() != null) {
			where.append(" AND t1.FECHA_RECEPCION_028 = ?");
			params.add(ab0428t00.getFechaRecepcion028());
		}

		if (ab0428t00 != null && ab0428t00.getFechaRecepcionDesde() != null) {
			where.append(" AND trunc(t1.FECHA_RECEPCION_028) >= trunc(?)");
			params.add(ab0428t00.getFechaRecepcionDesde());
		}

		if (ab0428t00 != null && ab0428t00.getFechaRecepcionHasta() != null) {
			where.append(" AND trunc(t1.FECHA_RECEPCION_028) <= trunc(?)");
			params.add(ab0428t00.getFechaRecepcionHasta());
		}

		if (ab0428t00 != null && ab0428t00.getFechaLectura028() != null) {
			where.append(" AND t1.FECHA_LECTURA_028 = ?");
			params.add(ab0428t00.getFechaLectura028());
		}
		if (ab0428t00 != null && ab0428t00.getRemitente028() != null) {
			where.append(" AND UPPER(t1.REMITENTE_028) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0428t00.getRemitente028().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0428t00.getRemitente028().toUpperCase() + "%");
			}
			where.append(" AND t1.REMITENTE_028 IS NOT NULL");
		}
		if (ab0428t00 != null && ab0428t00.getMensaje028() != null) {
			where.append(" AND UPPER(t1.MENSAJE_028) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0428t00.getMensaje028().toUpperCase() + "%");
			} else {
				params.add("%" + ab0428t00.getMensaje028().toUpperCase() + "%");
			}
			where.append(" AND t1.MENSAJE_028 IS NOT NULL");
		}
		if (ab0428t00 != null && ab0428t00.getAnoape028() != null) {
			where.append(" AND UPPER(t1.ANOAPE_028) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0428t00.getAnoape028().toUpperCase() + "%");
			} else {
				params.add("%" + ab0428t00.getAnoape028().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOAPE_028 IS NOT NULL");
		}
		if (ab0428t00 != null && ab0428t00.getTerape028() != null) {
			where.append(" AND UPPER(t1.TERAPE_028) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0428t00.getTerape028().toUpperCase() + "%");
			} else {
				params.add("%" + ab0428t00.getTerape028().toUpperCase() + "%");
			}
			where.append(" AND t1.TERAPE_028 IS NOT NULL");
		}
		if (ab0428t00 != null && ab0428t00.getNumape028() != null) {
			where.append(" AND t1.NUMAPE_028 = ?");
			params.add(ab0428t00.getNumape028());
		}

		if (ab0428t00 != null && ab0428t00.getLeido() != null) {
			if (ab0428t00.getLeido() == 1) {
				where.append(" AND t1.FECHA_LECTURA_028 is not null");
			} else {
				where.append(" AND t1.FECHA_LECTURA_028 is null");
			}
		}
		if (ab0428t00 != null && ab0428t00.getDestinatario028() != null) {
			where.append(" AND t1.DESTINATARIO_028 = ?");
			params.add(ab0428t00.getDestinatario028());
		}
		if (ab0428t00 != null && ab0428t00.getUsuariolectura028() != null) {
			where.append(" AND t1.USUARIO_LECTURA_028 = ?");
			params.add(ab0428t00.getUsuariolectura028());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
